/*
 * trimite date analogice de la  
 * Joystick conectat la A0 si A3 
 * 
 * primeste T si H de la partener
 * bibliografie link
 * */
//https://microcontrollerslab.com/esp32-esp-now-two-way-communication-arduino-ide/
#include <esp_now.h>
#include <WiFi.h>
#include <Wire.h>

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);

uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0x51, 0xEC};
//adresa partener

//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC7, 0x78};
//adresa proprie  CC:50:E3:B6:C7:78

  float temp;
  float hum;

   float x;
   float y;

float primitT; //date primite de la partener
float primitH;

String success;

//Must match the receiver structure
typedef struct struct_message {
    float temp;
    float hum; 
    float x;
    float y;   
} struct_message;


struct_message trimite;
struct_message primite;

// Callback when data is sent
void data_sent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
  if (status ==0){
    success = "Delivery Success :)";
  }
  else{
    success = "Delivery Fail :(";
  }
}

// Callback when data is received
void data_receive(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&primite, incomingData, sizeof(primite));
  Serial.print("Bytes received: ");
  Serial.println(len);
  primitT = primite.temp;
  primitH = primite.hum;
  //date primite de la partener
}
 
void setup() {

  Serial.begin(115200);
  //dht.begin();

  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Bilat EspNow");
  display.display();
  delay(2000);

 
  WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_send_cb(data_sent);
  
  esp_now_peer_info_t peerInfo;
  memcpy(peerInfo.peer_addr, broadcastAddress, 6);
  peerInfo.channel = 0;  
  peerInfo.encrypt = false;       
  if (esp_now_add_peer(&peerInfo) != ESP_OK){
    Serial.println("Failed to add peer");
    return;
  }
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(data_receive);
}
 
void loop() {
  trimite.x = analogRead(A0);
  trimite.y = analogRead(A3);
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &trimite, sizeof(trimite));
     
  if (result == ESP_OK) {
    Serial.println("Sent with success");
  }
  else {
    Serial.println("Error sending the data");
  }
  Display();
  delay(1000);
  }

void Display(){
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
  display.print("T: ");
  display.print(primitT);
  display.print("C");
  display.setCursor(0, 20);
  display.print("H: ");
  display.print(primitH);
  display.print("%");
  display.setCursor(0, 40);
  display.setTextSize(1);
  display.print(success);
  display.display();
  
 /* optional afisare pe monitor
  Serial.println("INCOMING READINGS");
  Serial.print("Temp: ");
  Serial.print(primite.temp);
  Serial.println(" ºC");
  Serial.print("Humi: ");
  Serial.print(primite.hum);
  Serial.println(" %");
  Serial.println();
  */
}
